local mainGear = {
	amortizer_max_length			= 0.267 + 0.056,-- strut + tire
	amortizer_basic_length			= 0.267 + 0.056,-- strut + tire
	amortizer_spring_force_factor		= 16000000.0,   -- force = spring_force_factor * pow(reduce_length, amortizer_spring_force_factor_rate
	amortizer_spring_force_factor_rate	= 4.0,
	amortizer_static_force			= 10000.0,
	amortizer_reduce_length			= 0.3,
	amortizer_direct_damper_force_factor	= 50000.0,
	amortizer_back_damper_force_factor	= 30000.0,
	allowable_hard_contact_length		= 0.215,
        wheel_radius				= 0.3224,
	wheel_static_friction_factor		= 0.70 ,
	wheel_side_friction_factor		= 0.35 ,
	wheel_roll_friction_factor		= 0.02 ,
	wheel_glide_friction_factor		= 0.30 ,
	wheel_damage_force_factor		= 450.0,
	wheel_brake_moment_max			= 5500.0,
	wheel_kz_factor				= 0.52,
	wheel_damage_speedX			= 115,
	wheel_damage_delta_speedX		= 11.5,
                   }
     -- Main Rotor control
       local MainRotorBladePitch0	        = 1.0	-- [deg]
       local MainCollectivePitch_min	        = 0.0	-- [deg]
       local MainCollectivePitch_max	        = 20.0	-- [deg]
       local SwashPlatePitch0		        = 0.0	-- [deg]
       local SwashPlateRoll0		        = 0.3	-- [deg]
--
AH64D = {
          imgui_permissions =
	            {
		    --PowerPlant                = true,
		    --EngineFailures            = true,
		    --MainRotorDamage           = true,
		    --CAS                       = true,
		    --SAS                       = true,
		    --SCAS                      = true,
		    --blade_angle_plot          = true,
		    --ihadds_adjustment         = true,
		    --WP                        = true,
		    --HF_Interface              = true,
		    --GearSystem                = true,
		    --HydroSystem               = true,
		    --SensorsSystem             = true,
		    --TADS                      = true,
		    --CG_and_MASS               = true,
		    --DigitalSlipBall           = true,
		    --APU                       = true,
		    --APU_ECU                   = true,
		    --SP_NAV                    = true,
		    --MPD_Cursor                = true,
		    --IPAS                      = true,
		    --TSE                       = true,
		    --drawArgs                  = true,
		    --CockpitDrawArgs           = true,
		    --FCR_GMT                   = true,
		    --FMC                       = true,
		    --GPS                       = true,
		    --EGI                       = true,
	             },
    keyboard_control =
	             {
		    -- speed of control levers when operating from the keyboard
		    -- use formula: speed [1/sec]   = full control range / full transfer time
		       cyclic_pitch_speed       = 2.0 / 15.0,
		       cyclic_roll_speed        = 2.0 / 15.0,
		       pedals_speed	        = 2.0 / 13.0,
		       collective_speed	        = 1.0 / 13.0,
	              },
   control_kinematics =
	              {
           collective =
		      {
		table =
		      {
	   -- format: { relative control, angle position [deg] }
		      { 0.0, MainRotorBladePitch0 + MainCollectivePitch_min},
		      { 1.0, MainRotorBladePitch0 + MainCollectivePitch_max},
		      },
		      },
pitch =
		      {
		table =
	 	      {
	   -- format: { relative control, angle position [deg] }
                      {-1.0,   -20.00 + SwashPlatePitch0},
                      {-0.975, -19.75 + SwashPlatePitch0},
                      {-0.95,  -19.00 + SwashPlatePitch0},
                      {-0.925, -18.25 + SwashPlatePitch0},
                      {-0.90,  -18.00 + SwashPlatePitch0},
                      {-0.875, -17.25 + SwashPlatePitch0},
                      {-0.85,  -17.00 + SwashPlatePitch0},
                      {-0.825, -16.25 + SwashPlatePitch0},
                      {-0.80,  -16.00 + SwashPlatePitch0},
                      {-0.775, -15.25 + SwashPlatePitch0},
                      {-0.75,  -15.00 + SwashPlatePitch0},
                      {-0.725, -14.25 + SwashPlatePitch0},
                      {-0.70,  -14.00 + SwashPlatePitch0},
                      {-0.675, -13.25 + SwashPlatePitch0},
                      {-0.65,  -13.00 + SwashPlatePitch0},
                      {-0.625, -12.25 + SwashPlatePitch0},
                      {-0.60,  -12.00 + SwashPlatePitch0},
                      {-0.575, -11.25 + SwashPlatePitch0},
                      {-0.55,  -11.00 + SwashPlatePitch0},
                      {-0.525, -10.25 + SwashPlatePitch0},
                      {-0.50,  -10.00 + SwashPlatePitch0},
                      {-0.475,  -9.25 + SwashPlatePitch0},
                      {-0.45,   -9.00 + SwashPlatePitch0},
                      {-0.425,  -8.25 + SwashPlatePitch0},
                      {-0.40,   -8.00 + SwashPlatePitch0},
                      {-0.375,  -7.25 + SwashPlatePitch0},
                      {-0.35,   -7.00 + SwashPlatePitch0},
                      {-0.325,  -6.25 + SwashPlatePitch0},
                      {-0.30,   -6.00 + SwashPlatePitch0},
                      {-0.275,  -5.25 + SwashPlatePitch0},
                      {-0.25,   -5.00 + SwashPlatePitch0},
                      {-0.225,  -4.25 + SwashPlatePitch0},
                      {-0.20,   -4.00 + SwashPlatePitch0},
                      {-0.175,  -3.25 + SwashPlatePitch0},
                      {-0.15,   -3.00 + SwashPlatePitch0},
                      {-0.125,  -2.25 + SwashPlatePitch0},
                      {-0.10,   -2.00 + SwashPlatePitch0},
                      {-0.075,  -1.25 + SwashPlatePitch0},
                      {-0.05,   -1.00 + SwashPlatePitch0},
                      {-0.025,  -0.25 + SwashPlatePitch0},
                      {0.00,    0.00  + SwashPlatePitch0},
                      {0.025,   0.25  + SwashPlatePitch0},
                      {0.05,    1.00  + SwashPlatePitch0},
                      {0.075,   1.75  + SwashPlatePitch0},
                      {0.10,    2.00  + SwashPlatePitch0},
                      {0.125,   2.75  + SwashPlatePitch0},
                      {0.15,    3.00  + SwashPlatePitch0},
                      {0.175,   3.75  + SwashPlatePitch0},
                      {0.20,    4.00  + SwashPlatePitch0},
                      {0.225,   4.75  + SwashPlatePitch0},
                      {0.25,    5.00  + SwashPlatePitch0},
                      {0.275,   5.75  + SwashPlatePitch0},
                      {0.30,    6.00  + SwashPlatePitch0},
                      {0.325,   6.75  + SwashPlatePitch0},
                      {0.35,    7.00  + SwashPlatePitch0},
                      {0.375,   7.75  + SwashPlatePitch0},
                      {0.40,    8.00  + SwashPlatePitch0},
                      {0.425,   8.75  + SwashPlatePitch0},
                      {0.45,    9.00  + SwashPlatePitch0},
                      {0.475,   9.75  + SwashPlatePitch0},
                      {0.50,   10.00  + SwashPlatePitch0},
                      {0.525,  10.75  + SwashPlatePitch0},
                      {0.55,   11.00  + SwashPlatePitch0},
                      {0.575,  11.75  + SwashPlatePitch0},
                      {0.60,   12.00  + SwashPlatePitch0},
                      {0.625,  12.75  + SwashPlatePitch0},
                      {0.65,   13.00  + SwashPlatePitch0},
                      {0.675,  13.75  + SwashPlatePitch0},
                      {0.70,   14.00  + SwashPlatePitch0},
                      {0.725,  14.75  + SwashPlatePitch0},
                      {0.75,   15.00  + SwashPlatePitch0},
                      {0.775,  15.75  + SwashPlatePitch0},
                      {0.80,   16.00  + SwashPlatePitch0},
                      {0.825,  16.75  + SwashPlatePitch0},
                      {0.85,   17.00  + SwashPlatePitch0},
                      {0.875,  17.75  + SwashPlatePitch0},
                      {0.90,   18.00  + SwashPlatePitch0},
                      {0.925,  18.75  + SwashPlatePitch0},
                      {0.95,   19.00  + SwashPlatePitch0},
                      {0.975,  19.75  + SwashPlatePitch0},
                      {1.0,    20.00  + SwashPlatePitch0},
                      },
		      },
roll =
		      {
	        table =
		      {
           -- format: { relative control, angle position [deg] }
                      {-1.0,   -10.00   + SwashPlateRoll0},
                      {-0.975, -9.7534  + SwashPlateRoll0},
                      {-0.95,  -9.50675 + SwashPlateRoll0},
                      {-0.925, -9.2622  + SwashPlateRoll0},
                      {-0.9,   -9.017   + SwashPlateRoll0},
                      {-0.875, -8.7724  + SwashPlateRoll0},
                      {-0.85,  -8.53075 + SwashPlateRoll0},
                      {-0.825, -8.2844  + SwashPlateRoll0},
                      {-0.8,   -8.048   + SwashPlateRoll0},
                      {-0.775, -7.8134  + SwashPlateRoll0},
                      {-0.75,  -7.56875 + SwashPlateRoll0},
                      {-0.725, -7.3305  + SwashPlateRoll0},
                      {-0.7,   -7.093   + SwashPlateRoll0},
                      {-0.675, -6.8572  + SwashPlateRoll0},
                      {-0.65,  -6.62075 + SwashPlateRoll0},
                      {-0.625, -6.3862  + SwashPlateRoll0},
                      {-0.6,   -6.152   + SwashPlateRoll0},
                      {-0.575, -5.91975 + SwashPlateRoll0},
                      {-0.55,  -5.68675 + SwashPlateRoll0},
                      {-0.525, -5.4535  + SwashPlateRoll0},
                      {-0.5,   -5.225   + SwashPlateRoll0},
                      {-0.475, -4.993   + SwashPlateRoll0},
                      {-0.45,  -4.76675 + SwashPlateRoll0},
                      {-0.425, -4.541   + SwashPlateRoll0},
                      {-0.4,   -4.312   + SwashPlateRoll0},
                      {-0.375, -4.087   + SwashPlateRoll0},
                      {-0.35,  -3.86075 + SwashPlateRoll0},
                      {-0.325, -3.6352  + SwashPlateRoll0},
                      {-0.3,   -3.413   + SwashPlateRoll0},
                      {-0.275, -3.1882  + SwashPlateRoll0},
                      {-0.25,  -2.9687  + SwashPlateRoll0},
                      {-0.225, -2.749   + SwashPlateRoll0},
                      {-0.2,   -2.528   + SwashPlateRoll0},
                      {-0.175, -2.3095  + SwashPlateRoll0},
                      {-0.15,  -2.09075 + SwashPlateRoll0},
                      {-0.125, -1.87025 + SwashPlateRoll0},
                      {-0.1,   -1.657   + SwashPlateRoll0},
                      {-0.075, -1.43975 + SwashPlateRoll0},
                      {-0.05,  -1.0675  + SwashPlateRoll0},
                      {-0.025, -1.0218  + SwashPlateRoll0},
                      {0.0,    -0.900   + SwashPlateRoll0},
                      {0.025,  -0.690   + SwashPlateRoll0},
                      {0.05,   -0.376   + SwashPlateRoll0},
                      {0.075,  -0.129   + SwashPlateRoll0},
                      {0.1,     0.043   + SwashPlateRoll0},
                      {0.125,   0.255   + SwashPlateRoll0},
                      {0.15,    0.45925 + SwashPlateRoll0},
                      {0.175,   0.6635  + SwashPlateRoll0},
                      {0.2,     0.872   + SwashPlateRoll0},
                      {0.225,   1.081   + SwashPlateRoll0},
                      {0.25,    1.28125 + SwashPlateRoll0},
                      {0.275,   1.48675 + SwashPlateRoll0},
                      {0.3,     1.687   + SwashPlateRoll0},
                      {0.325,   1.888   + SwashPlateRoll0},
                      {0.35,    2.08925 + SwashPlateRoll0},
                      {0.375,   2.28725 + SwashPlateRoll0},
                      {0.4,     2.488   + SwashPlateRoll0},
                      {0.425,   2.681   + SwashPlateRoll0},
                      {0.45,    2.88325 + SwashPlateRoll0},
                      {0.475,   3.081   + SwashPlateRoll0},
                      {0.5,     3.275   + SwashPlateRoll0},
                      {0.525,   3.470   + SwashPlateRoll0},
                      {0.55,    3.66325 + SwashPlateRoll0},
                      {0.575,   3.851   + SwashPlateRoll0},
                      {0.6,     4.048   + SwashPlateRoll0},
                      {0.625,   4.240   + SwashPlateRoll0},
                      {0.65,    4.42925 + SwashPlateRoll0},
                      {0.675,   4.617   + SwashPlateRoll0},
                      {0.7,     4.807   + SwashPlateRoll0},
                      {0.725,   4.992   + SwashPlateRoll0},
                      {0.75,    5.18125 + SwashPlateRoll0},
                      {0.775,   5.367   + SwashPlateRoll0},
                      {0.8,     5.552   + SwashPlateRoll0},
                      {0.825,   5.733   + SwashPlateRoll0},
                      {0.85,    5.91925 + SwashPlateRoll0},
                      {0.875,   6.100   + SwashPlateRoll0},
                      {0.9,     6.283   + SwashPlateRoll0},
                      {0.925,   6.462   + SwashPlateRoll0},
                      {0.95,    6.64325 + SwashPlateRoll0},
                      {0.975,   6.826   + SwashPlateRoll0},
                      {1.0,     7.00    + SwashPlateRoll0},
                      },
		      },
tail_collective_by_pedals =
		      {
	      range = { -22.0, 9.0 },	
		table =
		      {
                      {-1.00, -22.000},
		      {-0.98, -21.000},
		      {-0.96, -20.000},
		      {-0.94, -19.000},
		      {-0.92, -18.661},
		      {-0.90, -18.323},
		      {-0.88, -17.640},
		      {-0.86, -17.297},
		      {-0.84, -16.953},
		      {-0.82, -16.609},
		      {-0.80, -16.107},
		      {-0.78, -15.260},
		      {-0.76, -14.911},
		      {-0.74, -14.563},
		      {-0.72, -14.211},
		      {-0.70, -13.860},
		      {-0.68, -13.509},
		      {-0.66, -13.006},
		      {-0.64, -12.503},
		      {-0.62, -11.848},
		      {-0.60, -11.544},
		      {-0.58, -11.240},
		      {-0.56, -10.982},
		      {-0.54, -10.723},
		      {-0.52, -10.363},
		      {-0.50, -9.682},
		      {-0.48, -9.000},
		      {-0.46, -8.637},
		      {-0.44, -8.273},
		      {-0.42, -7.707},
		      {-0.40, -7.423},
		      {-0.38, -7.140},
		      {-0.36, -6.671},
		      {-0.34, -6.203},
		      {-0.32, -5.631},
		      {-0.30, -5.346},
		      {-0.28, -5.060},
		      {-0.26, -4.587},
		      {-0.24, -4.113},
		      {-0.22, -3.837},
		      {-0.20, -3.560},
		      {-0.18, -3.283},
		      {-0.16, -2.782},
		      {-0.14, -2.303},
		      {-0.12, -1.771},
		      {-0.10, -1.505},
		      {-0.08, -1.240},
		      {-0.06, -0.985},
		      {-0.04, -0.730},
		      {-0.02, -0.415},
		      {0.00, -0.257},
		      {0.02, -0.100},
		      {0.04, -0.061},
		      {0.06, -0.023},
		      {0.08, 0.016},
		      {0.10, 0.028},
		      {0.12, 0.040},
		      {0.14, 0.047},
		      {0.16, 0.053},
		      {0.18, 0.056},
		      {0.20, 0.058},
		      {0.22, 0.060},
		      {0.24, 0.067},
		      {0.26, 0.075},
		      {0.28, 0.083},
		      {0.30, 0.103},
		      {0.32, 0.123},
		      {0.34, 0.138},
		      {0.36, 0.146},
		      {0.38, 0.160},
		      {0.40, 0.200},
		      {0.42, 0.240},
		      {0.44, 0.281},
		      {0.46, 0.302},
		      {0.48, 0.323},
		      {0.50, 0.411},
		      {0.52, 0.500},
		      {0.54, 0.664},
		      {0.56, 0.996},
		      {0.58, 1.328},
		      {0.60, 1.744},
		      {0.62, 2.160},
		      {0.64, 2.579},
		      {0.66, 3.000},
		      {0.68, 3.419},
		      {0.70, 3.840},
		      {0.72, 4.264},
		      {0.74, 4.688},
		      {0.76, 5.114},
		      {0.78, 5.540},
		      {0.80, 5.969},
		      {0.82, 6.398},
		      {0.84, 6.829},
		      {0.86, 7.260},
		      {0.88, 7.694},
		      {0.90, 8.128},
		      {0.92, 8.564},
		      {0.94, 9.000},
		      {0.96, 9.000},
		      {0.98, 9.000},
		      {1.00, 9.000},
                      },
		      },
                      },
thrust_function =
	              {
	 -- format =  { TGT [deg C], THRUST [0..1] }
		      {40.0, 0.000 },
                      {50.0, 0.021 },
                      {68.6, 0.061 },
                      {80.0, 0.085 },
                      {97.1, 0.121 },
                      {110.0, 0.148 },
                      {125.7, 0.181 },
                      {140.0, 0.211 },
                      {154.3, 0.240 },
                      {182.9, 0.298 },
                      {211.4, 0.356 },
                      {240.0, 0.414 },
                      {268.6, 0.471 },
                      {297.1, 0.527 },
                      {325.7, 0.583 },
                      {354.3, 0.638 },
                      {382.9, 0.692 },
                      {411.4, 0.747 },
                      {420.0, 0.766 },
                      {430.0, 0.786 },
                      {440.0, 0.800 },
                      {451.0, 0.805 },
                      {460.0, 0.808 },
                      {468.9, 0.811 },
                      {475.0, 0.812 },
                      {486.8, 0.815 },
                      {495.0, 0.818 },
                      {504.6, 0.822 },
                      {522.5, 0.830 },
                      {540.4, 0.839 },
                      {558.2, 0.847 },
                      {576.1, 0.855 },
                      {594.0, 0.863 },
                      {611.9, 0.871 },
                      {629.8, 0.879 },
                      {647.6, 0.887 },
                      {665.5, 0.896 },
                      {683.4, 0.904 },
                      {701.2, 0.912 },
                      {710.0, 0.916 },
                      {719.1, 0.920 },
                      {730.0, 0.925 },
                      {737.0, 0.928 },
                      {745.0, 0.932 },
                      {754.9, 0.936 },
                      {765.0, 0.941 },
                      {772.8, 0.944 },
                      {785.0, 0.950 },
                      {790.6, 0.952 },
                      {800.0, 0.956 },
                      {808.5, 0.960 },
                      {815.0, 0.963 },
                      {826.4, 0.969 },
                      {835.0, 0.973 },
                      {844.2, 0.977 },
                      {855.0, 0.981 },
                      {862.1, 0.984 },
                      {870.0, 0.989 },
                      {880.0, 1.000 },
	              },

                      MainRotorPos                                      = {  0.30, 2.1,  0.000 },	
                      TailRotorPos                                      = { -8.725, 2.106, -0.721 },	
                   -- Damping coefficients at zero dynamic pressure
                      kDamp_Mx_s1	                                = 5.0, 
                      kDamp_My_s1	                                = 7.0,
                      kDamp_Mz_s1	                                = 45.0,
                      kDamp_Mx_s2	                                = -4000.0, 
                      kDamp_My_s2	                                = -17227,
                      kDamp_Mz_s2	                                = -4000.0, 
                   -- Damping coefficients at non-zero dynamic pressure
                      kDamp_Mx_d1	                                = -5.0,
                      kDamp_My_d1	                                = -120,
                      kDamp_Mz_d1	                                = -45.0,
                      kDamp_Mx_d2	                                = -4.0,
                      kDamp_My_d2	                                = -20.0,
                      kDamp_Mz_d2	                                = -20.0,
                   -- Rotor damping calibration coefficients
                      rotorDampCoeff_wx	                                = 3.3, 
                      rotorDampCoeff_wz	                                = 3.3, 
                   -- Rotor Ground Effect
                      rotorGroundEffectIntensity		        = 0.26,
                      rotorGroundEffectAttenuation	                = 0.06,
                      rotorGroundEffectDensCoeff		        = 0.7,
                      rotorGyroscopicMomentCoeff		        = 1.0,
                   -- Rotor roll due to critical flow at the advancing blade
                      rotorCritRollIntensity			        = 1.0,
                      rotorCritRollBladeMach			        = 0.7,
                      rotorCritRollGrowthRatio		                = 10.0,
                   -- Rotor induced velocity washout
                      rotorInducedVelocityWashout		        = 0.6,
                   -- main rotor blades animation
                      rotorFlapAnimationScaleMin		        = -30.0,
                      rotorFlapAnimationScaleMax		        =  30.0,
                   -- Scale of main rotor centrifugal force due to blade damage
                      rotorBladeDamageCentrifugalScale	                = 0.3,
                   -- Main rotor vortex ring parameters
                      mainRotorVortexRingWashout		        = 11.4,
                      mainRotorVortexRingK1			        = 0.399,
                      mainRotorVortexRingK2			        = 0.95,
                      mainRotorVortexRingK3			        = 2.66,
                      mainRotorVortexRingThrustLoss	                = 0.475,
                      mainRotorVortexRingCyclicLoss	                = 0.7695,
                      mainRotorVortexRingVibration	                = 0.171,
                   -- Main rotor hub stiffness coefficient
                      mainRotorStiffnessCoefficient	                = 0.032,
                   -- Tail rotor vortex ring parameters
                      tailRotorVortexRingWashout		        = 11.875,
                      tailRotorVortexRingK1			        = 2.85, 
                      tailRotorVortexRingK2			        = 3.99, 
                      tailRotorVortexRingK3			        = 12.35, 
                      tailRotorVortexRingThrustLoss	                = 0.1425, 
                   -- Tail rotor thrust filter parameters
                      tailRotorThrustFilterT1			        = 0.1,
                   -- gearbox and gear train parameters
                      totalTransmissionInertiaMoment	                = 8209.0262, 
                      zeroize_amortizers_before_collision_check = false,
                   -- Center of Mass and Moment of Inertia Data
                      center_of_mass = {0.150, 0.295, 0.0},  -- Current position after flight adjustments
                      moment_of_inertia = {9573, 51874, 51468, -5937},  -- Ix, Iy, Iz, Ixy values
                   -- SAS Gains 
                      pitchOutK                                         = 1.05,
                      rollOutK                                          = 1.0,
                      yawOutK                                           = 1.0,
                      pitchRateInputK                                   = 0.1,
                      rollRateInputK                                    = 0.1,
                      yawRateInputK                                     = 0.1,
                      pitchRateDirectFB_Coef                            = 0.4,  
                      rollRateDirectFB_Coef                             = 0.8,  
                      yawRateDirectFB_Coef                              = 0.1,
                      pitchStickK                                       = 0.75,
                      rollStickK                                        = 0.80,
                      pedalCoeff                                        = 0.5,
                      betaGain                                          = 6.0,  
                      betaDotGain                                       = 1.5,   
                      betaGainInt                                       = 0.1,
                      filterPeriod_roll                                 = 20.0,
                      filterPeriod_pitch                                = 40.0,
                   -- Hold parameters
                      headingHold_K_yaw                                 = 0.1,
                      headingHold_K_wy                                  = 0.1,
                      headingHold_K_int                                 = 0.1,
                      rollHold_K_roll                                   = 0.9,
                      rollHold_K_wx                                     = 0.5,
                      rollHold_K_int                                    = 0.4,
                      pitchHold_K_pitch                                 = 0.3,
                      pitchHold_K_wz                                    = 0.4,
                      pitchHold_K_int                                   = 0.3,
                      velHold_K_vx                                      = 1.5,
                      velHold_K_vz                                      = 1.5,
                      velHold_K_int                                     = 1.0,
                      pos_distance                                      = 8.0,
                      pos_dxMaxVal                                      = 0.1,
                      pos_dzMaxVal                                      = 0.1,
                      vyDamp                                            = 0.0,
                      altHold                                           = 0.02,
                      altHoldVy                                         = 0.12,
                      altInt                                            = 0.014,
                      attHold_cyclicStickPitch_threshold                = 2.5,
                      attHold_cyclicStickRoll_threshold                 = 2.25,
                      altHold_pitchRefAdd_max                           = 0.0,
                      altHold_alt_loss                                  = 5,
                      Kwx2                                              = 170.0,
                      Kwy2                                              = 400.0,
                      Kwz2                                              = 150.0,
                      Kwx2_hold                                         = 150.0,
                      Kwy2_hold                                         = 6.0,
                      Kwz2_hold                                         = 200.0,
suspension =
	         {
		 { -- TAIL WHEEL
		      damage_element				        = 83,
		      wheel_axle_offset			                = 0.1,
		      axle_angle				        = math.rad(5.0),
		      self_attitude				        = false,
		      yaw_limit				                = math.rad(180.0), --no need
		      moment_limit				        = 750.0,
		      damper_coeff				        = 50.0,
		      allowable_hard_contact_length	                = 0.25,
		      filter_yaw				        = false,
		      AxleFric0s				        = 190.0,
		      AxleFric0f				        = 4.0,
		      AxleFricVs				        = 0.1,
		      AxleFricVf				        = 1.0,
		      wheel_can_rotate_while_not_spin  	                = true,
		      axle_omega_limited			        = true,
		      axle_omega_limit			                = 2.0,
                      amortizer_min_length			        = 0.0,
		      amortizer_max_length			        = 0.246 + 0.030,	-- strut + tire
		      amortizer_basic_length			        = 0.246 + 0.030,	-- strut + tire
		      amortizer_spring_force_factor		        = 9000000.0, -- force = spring_force_factor * pow(reduce_length, amortizer_spring_force_factor_rate
		      amortizer_spring_force_factor_rate	        = 5,
		      amortizer_static_force			        = 1000.0,
		      amortizer_reduce_length			        = 0.2,
                      amortizer_direct_damper_force_factor	        = 40000,
		      amortizer_back_damper_force_factor	        = 20000,
                      wheel_radius				        = 0.1614,
		      wheel_static_friction_factor                      = 0.6,
		      wheel_side_friction_factor                        = 1.0,
		      wheel_roll_friction_factor                        = 0.9,
		      wheel_glide_friction_factor                       = 0.97,
		      wheel_damage_force_factor                         = 450.0,
		      wheel_damage_speedX                               = 115,
		      wheel_damage_delta_speedX                         = 11.5,
                      arg_post		                                = 0,
		      arg_amortizer		                        = 1,
		      arg_wheel_rotation	                        = 101,
		      arg_wheel_damage	                                = 134
		 },
		 { -- LEFT WHEEL
		      damage_element					= 84,
                      amortizer_max_length				= mainGear.amortizer_max_length,
		      amortizer_basic_length				= mainGear.amortizer_basic_length,
		      amortizer_spring_force_factor			= mainGear.amortizer_spring_force_factor,
		      amortizer_spring_force_factor_rate		= mainGear.amortizer_spring_force_factor_rate,
		      amortizer_static_force				= mainGear.amortizer_static_force,
		      amortizer_reduce_length				= mainGear.amortizer_reduce_length,
		      amortizer_direct_damper_force_factor	        = mainGear.amortizer_direct_damper_force_factor,
		      amortizer_back_damper_force_factor		= mainGear.amortizer_back_damper_force_factor,
		      allowable_hard_contact_length			= mainGear.allowable_hard_contact_length,
                      wheel_radius					= mainGear.wheel_radius,
		      wheel_static_friction_factor			= mainGear.wheel_static_friction_factor,
		      wheel_side_friction_factor			= mainGear.wheel_side_friction_factor,
		      wheel_roll_friction_factor			= mainGear.wheel_roll_friction_factor,
		      wheel_glide_friction_factor			= mainGear.wheel_glide_friction_factor,
		      wheel_damage_force_factor			        = mainGear.wheel_damage_force_factor,
		      wheel_brake_moment_max				= mainGear.wheel_brake_moment_max,
		      wheel_kz_factor					= mainGear.wheel_kz_factor,
		      wheel_damage_speedX				= mainGear.wheel_damage_speedX,
		      wheel_damage_delta_speedX			        = mainGear.wheel_damage_delta_speedX,
                      arg_post		                                = 5,
		      arg_amortizer		                        = 6,
		      arg_wheel_rotation	                        = 103,
		      arg_wheel_damage	                                = 136
		 },
		 { -- RIGHT WHEEL
		      damage_element		                        = 85,
                      amortizer_max_length				= mainGear.amortizer_max_length,
		      amortizer_basic_length				= mainGear.amortizer_basic_length,
		      amortizer_spring_force_factor			= mainGear.amortizer_spring_force_factor,
		      amortizer_spring_force_factor_rate		= mainGear.amortizer_spring_force_factor_rate,
		      amortizer_static_force				= mainGear.amortizer_static_force,
		      amortizer_reduce_length				= mainGear.amortizer_reduce_length,
		      amortizer_direct_damper_force_factor	        = mainGear.amortizer_direct_damper_force_factor,
		      amortizer_back_damper_force_factor		= mainGear.amortizer_back_damper_force_factor,
		      allowable_hard_contact_length			= mainGear.allowable_hard_contact_length,
                      wheel_radius					= mainGear.wheel_radius,
		      wheel_static_friction_factor			= mainGear.wheel_static_friction_factor,
		      wheel_side_friction_factor			= mainGear.wheel_side_friction_factor,
		      wheel_roll_friction_factor			= mainGear.wheel_roll_friction_factor,
		      wheel_glide_friction_factor			= mainGear.wheel_glide_friction_factor,
		      wheel_damage_force_factor			        = mainGear.wheel_damage_force_factor,
		      wheel_brake_moment_max				= mainGear.wheel_brake_moment_max,
		      wheel_kz_factor					= mainGear.wheel_kz_factor,
		      wheel_damage_speedX				= mainGear.wheel_damage_speedX,
		      wheel_damage_delta_speedX			        = mainGear.wheel_damage_delta_speedX,
                      arg_post		                                = 3,
		      arg_amortizer		                        = 4,
		      arg_wheel_rotation	                        = 102,
		      arg_wheel_damage	                                = 135
	       },
	       }, -- suspension/gears

disable_built_in_oxygen_system	= true,
        --
 balancing = {
 
                      {0.00, -0.024,  0.054, -0.241, 11.90}, 
                      {1.66, -0.005,  0.043, -0.228, 11.70}, 
                      {3.32,  0.014,  0.032, -0.215, 11.50}, 
                      {4.98,  0.033,  0.021, -0.202, 11.30}, 
                      {6.64,  0.053,  0.011, -0.189, 11.10}, 
                      {7.18,  0.058,  0.010, -0.185, 11.05}, 
                      {7.72,  0.064,  0.010, -0.182, 11.00}, 
                      {8.26,  0.069,  0.009, -0.178, 10.95},
                      {8.80,  0.074,  0.008, -0.175, 10.90}, 
                      {9.97,  0.071,  0.006, -0.152, 10.80}, 
                      {11.15, 0.069,  0.004, -0.129, 10.70}, 
                      {12.32, 0.066,  0.002, -0.106, 10.60}, 
                      {13.50, 0.064,  0.000, -0.083, 10.50}, 
                      {15.72, 0.061, -0.011, -0.056, 10.36}, 
                      {17.95, 0.058, -0.022, -0.030, 10.22}, 
                      {20.17, 0.055, -0.033, -0.004, 10.08}, 
                      {22.40, 0.052, -0.044,  0.022,  9.94}, 
                      {24.17, 0.048, -0.058,  0.032,  9.85}, 
                      {25.95, 0.044, -0.072,  0.043,  9.77}, 
                      {27.72, 0.040, -0.086,  0.053,  9.68}, 
                      {29.50, 0.036, -0.100,  0.064,  9.60}, 
                      {29.95, 0.034, -0.104,  0.072,  9.62}, 
                      {30.40, 0.032, -0.109,  0.080,  9.65}, 
                      {30.85, 0.029, -0.114,  0.088,  9.67}, 
                      {31.30, 0.027, -0.119,  0.097,  9.70}, 
                      {33.05, 0.023, -0.135,  0.095,  9.77}, 
                      {34.80, 0.020, -0.152,  0.093,  9.85}, 
                      {36.55, 0.016, -0.169,  0.091,  9.92}, 
                      {38.30, 0.012, -0.186,  0.089, 10.00}, 
                      {40.60, 0.009, -0.211,  0.082, 10.22}, 
                      {42.90, 0.006, -0.237,  0.076, 10.45}, 
                      {45.20, 0.003, -0.263,  0.070, 10.67}, 
                      {47.50, 0.000, -0.289,  0.064, 10.90}, 
                      {49.19, 0.000, -0.313,  0.055, 11.20}, 
                      {50.88, 0.000, -0.338,  0.047, 11.50}, 
                      {52.56, 0.000, -0.362,  0.038, 11.80}, 
                      {54.25, 0.000, -0.387,  0.030, 12.10}, 
                      {54.90, -0.002, -0.398,  0.026, 12.22}, 
                      {55.55, -0.005, -0.409,  0.022, 12.35}, 
                      {56.20, -0.007, -0.420,  0.018, 12.47}, 
                      {56.85, -0.010, -0.432,  0.014, 12.60}, 
                      {58.01, -0.009, -0.450, -0.001, 12.91}, 
                      {59.18, -0.009, -0.469, -0.016, 13.22}, 
                      {60.34, -0.008, -0.487, -0.031, 13.53}, 
                      {61.50, -0.008, -0.506, -0.047, 13.85}, 
                      {62.70, -0.008, -0.520, -0.068, 14.21}, 
                      {63.90, -0.008, -0.535, -0.089, 14.58}, 
                      {65.10, -0.008, -0.550, -0.110, 14.94}, 
                      {66.30, -0.008, -0.565, -0.131, 15.30}, 
                      {66.92, -0.002, -0.578, -0.158, 15.50}, 
                      {67.55,  0.004, -0.592, -0.185, 15.70}, 
                      {68.17,  0.010, -0.605, -0.212, 15.90}, 
                      {68.80,  0.016, -0.619, -0.240, 16.10}, 
                      {69.30,  0.006, -0.628, -0.198, 16.52}, 
                      {69.80, -0.003, -0.638, -0.157, 16.95}, 
                      {70.30, -0.012, -0.647, -0.116, 17.37}, 
                      {70.80, -0.022, -0.657, -0.075, 17.80}, 
},
-- FFB force multiplier
	ffbPitchK	    = 0.85,
	ffbRollK	    = 0.75,
        -- view shake amplitude
	minor_shake_ampl    = 0.02,
	major_shake_ampl    = 0.15,
} -- end of AH64D
   